<?php get_header(); ?>
	<article>
		<div class="archive_header">
			<div class="inner">
				<h1 class="title">ニュース一覧</h1>
			</div>
		</div>
		<section>
			<div class="inner">
				<div class="paragraph">
					<ol class="news_list">
						<?php while ( have_posts() ) : the_post(); ?>
							<li>
								<a href="<?php the_permalink(); ?>">
								<time class="news_list_date updated" datetime="<?php the_modified_time('c'); ?>"><?php the_time('Y.m.d'); ?></time>
								<span class="news_list_title"><?php the_title(); ?></span>
								</a>
							</li>
						<?php endwhile; ?>
					</ol>
				</div>
			</div>
		</section>
		<section class="section_pagenation">
			<div class="inner">
				<div class="paragraph">
					<?php
						$prev_link = get_previous_posts_link('前へ');
						$next_link = get_next_posts_link('次へ');
						if (isset($prev_link) or isset($next_link)) {
							echo "<ul class=\"pagination\">", PHP_EOL;
							echo "<li class=\"btnPrev\">";
							if(isset($prev_link)) {
								echo $prev_link;
							}
							echo "</li>", PHP_EOL;
							echo "<li class=\"btnTop\"><a href=\"";
							echo get_pagenum_link(1);
							echo "\">先頭に戻る</a></li>";
							echo "<li class=\"btnNext\">";
							echo $next_link;
							echo "</li>", PHP_EOL;
							echo '</ul>', PHP_EOL;
						}
					?>
				</div>
			</div>
		</section>
	</article>
<?php get_footer(); ?>
